IF EXISTS( SELECT 1 FROM SYS.procedures
			WHERE NAME = 'P_TELE_ORC_PAG_CARTAO_PDV_VD_DINHEIRO')
    BEGIN
        DROP PROCEDURE P_TELE_ORC_PAG_CARTAO_PDV_VD_DINHEIRO;
    END;
GO


/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Descricao...........: Relatrio de Acompanhamento de Vendas.
'Verso..............: 20221117
'Nome................: P_TELE_ORC_PAG_CARTAO_PDV_VD_DINHEIRO
'Job.................: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 2022-11-17
'Alterado por........: Marcos_Barros
'Modificao_2.......: 
'Criado por..........: 
'=======================================================================================
*/


CREATE PROCEDURE [dbo].[P_TELE_ORC_PAG_CARTAO_PDV_VD_DINHEIRO]
AS
SET NOCOUNT ON;
DECLARE @ERRORMESSAGE NVARCHAR(4000);  
DECLARE @ERRORSEVERITY INT;  
DECLARE @ERRORSTATE INT;  
DECLARE @ERRORNUMBER INT = ERROR_NUMBER();
DECLARE @VL_DINHEIRO NUMERIC(15,2);
DECLARE @VL_CARTAO NUMERIC(15,2);
DECLARE @MESSAGE VARCHAR(2047);
-----------------------------------------------------------------------------------------------------
	IF OBJECT_ID ('TEMPDB.DBO.#TMP_PDV_VD_CARTAO_DINHEIRO') IS NOT NULL
	BEGIN
		DROP TABLE #TMP_PDV_VD_CARTAO_DINHEIRO 
	END
	CREATE TABLE #TMP_PDV_VD_CARTAO_DINHEIRO (CD_EMP		INT,
									CD_FILIAL	INT,
									CD_VD		INT,
									CD_ORC      INT,
									CD_ORC_PAG	INT
									);
	INSERT INTO #TMP_PDV_VD_CARTAO_DINHEIRO
	SELECT 
		  V.CD_EMP
		, V.CD_FILIAL
		, V.CD_VD
		, O.CD_ORC
		, PE.CD_ORC_PAG
	FROM 
		TELE_ORC_PAG P
		JOIN TELE_ORC_PAG_DINHEIRO_PENDENTE PE ON P.CD_ORC_PAG = PE.CD_ORC_PAG
		JOIN TELE_ORC O ON P.CD_ORC = O.CD_ORC 
		JOIN PDV_VD V ON O.CD_ORC = V.NR_PED_TELEVD AND
			O.CD_EMP = V.CD_EMP AND
			O.CD_FILIAL = V.CD_FILIAL 
	WHERE P.CD_TIPO_PAG IN(1,2)
		AND NOT EXISTS (SELECT 1 FROM PDV_VD_FECHA_MOV MOV  WHERE MOV.CD_EMP = V.CD_EMP AND MOV.CD_FILIAL = V.CD_FILIAL AND MOV.DT_MOV = V.DT_VD AND MOV.BLQ_ALT_FECHA = 1);
-----------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------
	BEGIN TRY
		DECLARE @CD_ORC_AJUSTA INT
		DECLARE @CD_ORC_PAG_AJUSTA INT
		DECLARE @CD_FILIAL_AJUSTA INT
		DECLARE @CD_VD_AJUSTA INT
		DECLARE @CD_EMP_AJUSTA INT
		DECLARE @MV_LOTE INT
		DECLARE @I INT = 1
		SET NOCOUNT ON
		DECLARE AJUSTA_TROCA_RECEBIMENTO CURSOR FAST_FORWARD FOR 
		SELECT DISTINCT CD_ORC, CD_FILIAL, CD_VD, CD_EMP, CD_ORC_PAG
		FROM #TMP_PDV_VD_CARTAO_DINHEIRO
		--CRIANDO UM CURSOR PARA TRATAR PEDIDO A PEDIDO OS DADOS DOS CUPONS FISCAIS VINCULADOS A CADA PEDIDO
		OPEN AJUSTA_TROCA_RECEBIMENTO
		FETCH NEXT FROM AJUSTA_TROCA_RECEBIMENTO INTO @CD_ORC_AJUSTA,@CD_FILIAL_AJUSTA,@CD_VD_AJUSTA,@CD_EMP_AJUSTA,@CD_ORC_PAG_AJUSTA
		WHILE @@FETCH_STATUS=0
		BEGIN
			IF (@I % 1) = 0 
			BEGIN
				--ATUALIZANDO VALOR DE DINHEIRO E CARTO DO CUPOM FISCAL COM BASE NO RETORNO DO MOTOCICLISTA
				UPDATE PDV_VD SET VLR_CARTAO=0,VLR_DINH=0 WHERE CD_EMP=@CD_EMP_AJUSTA AND CD_FILIAL=@CD_FILIAL_AJUSTA AND CD_VD=@CD_VD_AJUSTA;
				SET @VL_DINHEIRO=0;
				SET @VL_CARTAO=0;
				SELECT @VL_DINHEIRO=SUM(VLR_PAG)-SUM(VLR_TROCO) FROM TELE_ORC_PAG WHERE CD_ORC = @CD_ORC_AJUSTA AND CD_TIPO_PAG = 1;
				SELECT @VL_CARTAO=SUM(VLR_PAG)-SUM(VLR_TROCO) FROM TELE_ORC_PAG WHERE CD_ORC = @CD_ORC_AJUSTA AND CD_TIPO_PAG = 2;
				UPDATE PDV_VD SET VLR_DINH = @VL_DINHEIRO, VLR_CARTAO = @VL_CARTAO WHERE CD_EMP=@CD_EMP_AJUSTA AND CD_FILIAL=@CD_FILIAL_AJUSTA AND CD_VD=@CD_VD_AJUSTA;
				--REMOVENDO O VINCULO DOS CARTES COM O CUPOM FISCAL J LANADOS
                DELETE FROM T FROM PDV_VD_TEF T
				WHERE T.CD_EMP=@CD_EMP_AJUSTA AND T.CD_FILIAL=@CD_FILIAL_AJUSTA AND T.CD_VD=@CD_VD_AJUSTA 
					AND NOT EXISTS(SELECT V.CD_EMP FROM RC_ADM_CARTAO_MOV_LOTE_PDV_VD V WHERE T.CD_EMP = V.CD_EMP 
						AND T.CD_FILIAL	= V.CD_FILIAL 
						AND T.CD_VD = V.CD_VD);
				SET @MV_LOTE = 0;
				SELECT @MV_LOTE = V.CD_EMP FROM RC_ADM_CARTAO_MOV_LOTE_PDV_VD V WHERE V.CD_EMP = @CD_EMP_AJUSTA
						AND V.CD_FILIAL = @CD_FILIAL_AJUSTA
						AND V.CD_VD = @CD_VD_AJUSTA
				IF @MV_LOTE <> 1
				BEGIN
					-- INSERE REGISTROS DO TEF
					INSERT INTO PDV_VD_TEF(CD_EMP,CD_FILIAL,CD_VD, CD_TRN_TEF,CD_ADM_CARTAO,NR_AUTORIZACAO
											,COD_REDE,COD_MODALIDADE,COD_BANDEIRA,VL_CARTAO,NSU_SITEF,VL_SAQUE_CARTAO,DT_CONSD
											,NR_ECF_ADM,CD_CX_ADM,DT_VD_ADM,CANCEL_TEF,CONC_CARTAO,TP_ADM,NM_OPERADORA_PDV
											,QTDE_PARCELAS,TEF_GATEWAY,MODALIDADE,NR_COMPROVANTE,NR_ESTABELECIMENTO,VL_TOTAL_DOACAO
											,IDT_TRANSACAO,T_BAND)
					SELECT V.CD_EMP
						, V.CD_FILIAL
						, V.CD_VD 
						, 0 CD_TRN_TEF
						, C.CD_ADM_CARTAO
						, C.NR_AUTORIZACAO
						, 0 COD_REDE
						, 0 COD_MODALIDADE
						, 0 COD_BANDEIRA
						, C.VL_CARTAO
						, CASE WHEN ISNUMERIC(C.NSU)=1 THEN  CONVERT(MONEY,C.NSU) ELSE 00.0 END 
						, 0 VL_SAQUE_CARTAO
						, GETDATE() DT_CONSD
						, V.NR_ECF
						, V.CD_CX
						, V.DT_VD
						, 0 CANCEL_TEF
						, 0 CONC_CARTAO
						, A.TP_ADM
						, '' NM_OPERADORA_PDV
						, C.QTDE_PARC
						, '' TEF_GATEWAY
						, '' MODALIDADE
						, '' NR_COMPROVANTE
						, '' NR_ESTABELECIMENTO
						, 0 VL_TOTAL_DOACAO
						, NULL IDT_TRANSACAO
						, NULL T_BAND 
					FROM TELE_ORC_PAG P
						JOIN TELE_ORC_PAG_CARTAO C ON P.CD_ORC_PAG = C.CD_ORC_PAG
						JOIN TELE_ORC O ON P.CD_ORC = O.CD_ORC
						JOIN PDV_VD V ON O.CD_ORC = V.NR_PED_TELEVD 
							AND O.CD_EMP = V.CD_EMP 
							AND O.CD_FILIAL = V.CD_FILIAL
						JOIN RC_ADM_CARTAO A ON C.CD_ADM_CARTAO  = A.CD_ADM_CARTAO
					WHERE O.CD_ORC = @CD_ORC_AJUSTA
						AND O.CD_FILIAL = @CD_FILIAL_AJUSTA
						AND O.CD_EMP = @CD_EMP_AJUSTA;
				END				
				--REMOVENDO DA PENDENCIA DE TRATATIVA
				DELETE FROM TELE_ORC_PAG_DINHEIRO_PENDENTE WHERE CD_ORC_PAG = @CD_ORC_PAG_AJUSTA;
			END		  		  
				SET @I  = @I + 1
			FETCH NEXT FROM AJUSTA_TROCA_RECEBIMENTO INTO @CD_ORC_AJUSTA,@CD_FILIAL_AJUSTA,@CD_VD_AJUSTA,@CD_EMP_AJUSTA,@CD_ORC_PAG_AJUSTA
		END
		--AJUSTA_TROCA_RECEBIMENTONDO CURSOS
		CLOSE AJUSTA_TROCA_RECEBIMENTO;
		--DESALOCANDO CURSOS DA MEMORIA
		DEALLOCATE AJUSTA_TROCA_RECEBIMENTO;
		--APAGANDO A TABELA TEMPORARIA
		DROP TABLE #TMP_PDV_VD_CARTAO_DINHEIRO
	END TRY
	BEGIN CATCH
		SELECT   
			@ERRORMESSAGE = ERROR_MESSAGE(),  
			@ERRORSEVERITY = ERROR_SEVERITY(),  
			@ERRORSTATE = ERROR_STATE();  
		RAISERROR (@ERRORMESSAGE,@ERRORSEVERITY,@ERRORSTATE);  
	END CATCH 	

GO


